/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.util.RenderContextList;
import team.chisel.ctm.client.model.ModelUtil;
import team.chisel.ctm.client.state.CTMContext;
import team.chisel.ctm.client.util.ProfileUtil;

public abstract class AbstractCTMBakedModel
implements IDynamicBakedModel {
    private static Cache<ModelResourceLocation, AbstractCTMBakedModel> itemcache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private static Cache<State, AbstractCTMBakedModel> modelcache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(5000L).build();
    @Nonnull
    private final IModelCTM model;
    @Nonnull
    private final BakedModel parent;
    @Nonnull
    private final Overrides overrides = new Overrides();
    protected final ListMultimap<RenderType, BakedQuad> genQuads = MultimapBuilder.hashKeys().arrayListValues().build();
    protected final Table<RenderType, Direction, List<BakedQuad>> faceQuads = Tables.newCustomTable(new HashMap(), () -> Maps.newEnumMap(Direction.class));
    private final EnumMap<Direction, ImmutableList<BakedQuad>> noLayerCache = new EnumMap(Direction.class);
    private ImmutableList<BakedQuad> noSideNoLayerCache;
    protected static final ModelProperty<CTMContext> CTM_CONTEXT = new ModelProperty();
    protected static final RenderType[] LAYERS = RenderType.m_110506_().toArray(new RenderType[0]);

    public static void invalidateCaches() {
        itemcache.invalidateAll();
        modelcache.invalidateAll();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        ImmutableList<BakedQuad> ret;
        BakedModel parent = this.getParent(rand);
        ProfileUtil.start("ctm_models");
        AbstractCTMBakedModel baked = this;
        RenderType layer = MinecraftForgeClient.getRenderType();
        try {
            if (Minecraft.m_91087_().f_91073_ != null && extraData.hasProperty(CTM_CONTEXT)) {
                ProfileUtil.start("state_creation");
                RenderContextList ctxList = ((CTMContext)extraData.getData(CTM_CONTEXT)).getContextList(state, baked);
                Object2LongMap<ICTMTexture<?>> serialized = ctxList.serialized();
                ProfileUtil.endAndStart("model_creation");
                baked = (AbstractCTMBakedModel)modelcache.get((Object)new State(state, serialized, parent), () -> this.createModel(state, this.model, parent, ctxList, rand));
                ProfileUtil.end();
            } else if (state != null) {
                ProfileUtil.start("model_creation");
                baked = (AbstractCTMBakedModel)modelcache.get((Object)new State(state, null, parent), () -> this.createModel(state, this.model, parent, null, rand));
                ProfileUtil.end();
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        ProfileUtil.start("quad_lookup");
        if (side != null && layer != null) {
            ret = (List)baked.faceQuads.get((Object)layer, (Object)side);
        } else if (side != null) {
            AbstractCTMBakedModel _baked = baked;
            ret = (List)baked.noLayerCache.computeIfAbsent(side, f -> ImmutableList.copyOf(_baked.faceQuads.column(f).values().stream().flatMap(Collection::stream).distinct().toList()));
        } else if (layer != null) {
            ret = baked.genQuads.get((Object)layer);
        } else {
            ret = baked.noSideNoLayerCache;
            if (ret == null) {
                ret = baked.noSideNoLayerCache = ImmutableList.copyOf(baked.genQuads.values().stream().distinct().toList());
            }
        }
        ProfileUtil.end();
        ProfileUtil.end();
        if (ret == null) {
            throw new IllegalStateException("getQuads called on a model that was not properly initialized - by using getOverrides and/or getModelData");
        }
        return ret;
    }

    public IModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, IModelData tileData) {
        if (tileData == EmptyModelData.INSTANCE) {
            tileData = new ModelDataMap.Builder().withProperty(CTM_CONTEXT).build();
        }
        tileData.setData(CTM_CONTEXT, (Object)new CTMContext((BlockGetter)world, pos));
        return tileData;
    }

    @Nonnull
    public BakedModel getParent(Random rand) {
        BakedModel bakedModel = this.getParent();
        if (bakedModel instanceof WeightedBakedModel) {
            WeightedBakedModel weightedBakedModel = (WeightedBakedModel)bakedModel;
            Optional model = WeightedRandom.m_146314_((List)weightedBakedModel.f_119541_, (int)(Math.abs((int)rand.nextLong()) % ((WeightedBakedModel)this.getParent()).f_119540_));
            if (model.isPresent()) {
                return (BakedModel)((WeightedEntry.Wrapper)model.get()).m_146310_();
            }
        }
        return this.getParent();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public boolean m_7541_() {
        return this.parent.m_7541_();
    }

    public boolean m_7539_() {
        return this.parent.m_7539_();
    }

    public boolean m_7521_() {
        return this.parent.m_7521_();
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.parent.m_6160_();
    }

    @Nonnull
    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack poseStack) {
        this.parent.handlePerspective(cameraTransformType, poseStack);
        return this;
    }

    protected abstract AbstractCTMBakedModel createModel(BlockState var1, @Nonnull IModelCTM var2, BakedModel var3, RenderContextList var4, Random var5);

    public boolean m_7547_() {
        return this.getParent().m_7547_();
    }

    private <T> T applyToParent(Random rand, Function<AbstractCTMBakedModel, T> func) {
        BakedModel parent = this.getParent(rand);
        if (parent instanceof AbstractCTMBakedModel) {
            AbstractCTMBakedModel ctmBakedModel = (AbstractCTMBakedModel)parent;
            return func.apply(ctmBakedModel);
        }
        return null;
    }

    protected ICTMTexture<?> getOverrideTexture(Random rand, int tintIndex, ResourceLocation texture) {
        ICTMTexture ret = this.getModel().getOverrideTexture(tintIndex, texture);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getOverrideTexture(rand, tintIndex, texture));
        }
        return ret;
    }

    protected ICTMTexture<?> getTexture(Random rand, ResourceLocation texture) {
        ICTMTexture ret = this.getModel().getTexture(texture);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getTexture(rand, texture));
        }
        return ret;
    }

    protected TextureAtlasSprite getOverrideSprite(Random rand, int tintIndex) {
        TextureAtlasSprite ret = this.getModel().getOverrideSprite(tintIndex);
        if (ret == null) {
            ret = this.applyToParent(rand, parent -> parent.getOverrideSprite(rand, tintIndex));
        }
        return ret;
    }

    public Collection<ICTMTexture<?>> getCTMTextures() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.getModel().getCTMTextures());
        if (this.getParent() instanceof AbstractCTMBakedModel) {
            builder.addAll(((AbstractCTMBakedModel)this.getParent()).getCTMTextures());
        }
        return builder.build();
    }

    public AbstractCTMBakedModel(@Nonnull IModelCTM model, @Nonnull BakedModel parent) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        this.model = model;
        this.parent = parent;
    }

    @Nonnull
    public IModelCTM getModel() {
        return this.model;
    }

    @Nonnull
    public BakedModel getParent() {
        return this.parent;
    }

    private static class State {
        @Nonnull
        private final BlockState cleanState;
        @Nullable
        private final Object2LongMap<ICTMTexture<?>> serializedContext;
        @Nonnull
        private final BakedModel parent;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            State other = (State)obj;
            if (this.cleanState != other.cleanState) {
                return false;
            }
            if (this.parent != other.parent) {
                return false;
            }
            return !(this.serializedContext == null ? other.serializedContext != null : !this.serializedContext.equals(other.serializedContext));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + System.identityHashCode(this.cleanState);
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            result = 31 * result + (this.serializedContext == null ? 0 : this.serializedContext.hashCode());
            return result;
        }

        @Nonnull
        public BlockState getCleanState() {
            return this.cleanState;
        }

        @Nullable
        public Object2LongMap<ICTMTexture<?>> getSerializedContext() {
            return this.serializedContext;
        }

        @Nonnull
        public BakedModel getParent() {
            return this.parent;
        }

        public State(@Nonnull BlockState cleanState, @Nullable Object2LongMap<ICTMTexture<?>> serializedContext, @Nonnull BakedModel parent) {
            if (cleanState == null) {
                throw new NullPointerException("cleanState is marked non-null but is null");
            }
            if (parent == null) {
                throw new NullPointerException("parent is marked non-null but is null");
            }
            this.cleanState = cleanState;
            this.serializedContext = serializedContext;
            this.parent = parent;
        }

        public String toString() {
            return "AbstractCTMBakedModel.State(cleanState=" + this.getCleanState() + ", serializedContext=" + this.getSerializedContext() + ", parent=" + this.getParent() + ")";
        }
    }

    @ParametersAreNonnullByDefault
    private class Overrides
    extends ItemOverrides {
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, ClientLevel world, LivingEntity entity, int unknown) {
            Block block = null;
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                block = blockItem.m_40614_();
            }
            BlockState state = block == null ? null : block.m_49966_();
            ModelResourceLocation mrl = ModelUtil.getMesh(stack);
            if (mrl == null) {
                return Minecraft.m_91087_().m_91289_().m_110907_().m_110881_().m_119409_();
            }
            Random random = new Random();
            random.setSeed(42L);
            return (BakedModel)itemcache.get((Object)mrl, () -> AbstractCTMBakedModel.this.createModel(state, AbstractCTMBakedModel.this.model, AbstractCTMBakedModel.this.getParent(random), null, random));
        }
    }
}

